// Test program in C to see behavior of IMG_Load()

#include <SDL2/SDL.h>
#include <SDL2/SDL_image.h>

static const int WIN_WIDTH = 800;
static const int WIN_HEIGHT = 600;

int main()
{
	SDL_Window *window = SDL_CreateWindow(
			"Go-SDL2 Texture - C version",
			SDL_WINDOWPOS_UNDEFINED, SDL_WINDOWPOS_UNDEFINED,
			WIN_WIDTH, WIN_HEIGHT,
			SDL_WINDOW_SHOWN);
	if (!window) {
		fprintf(stderr, "Failed to create window: %s\n", SDL_GetError());
		return 1;
	}

	SDL_Renderer *renderer = SDL_CreateRenderer(window, -1, SDL_RENDERER_ACCELERATED);
	if (!renderer) {
		fprintf(stderr, "Failed to create renderer: %s\n", SDL_GetError());
		return 2;
	}

	SDL_Surface *image = IMG_Load("kasa.png");
	if (!image) {
		fprintf(stderr, "Failed to load PNG: %s\n", SDL_GetError());
		return 3;
	}

	SDL_Surface *imagebg = IMG_Load("j.png");
	if (!imagebg) {
		fprintf(stderr, "Failed to load PNG: %s\n", SDL_GetError());
		return 3;
	}
	SDL_Surface *imagebalo = IMG_Load("balo.png");
	if (!imagebalo) {
		fprintf(stderr, "Failed to load PNG: %s\n", SDL_GetError());
		return 3;
	}
	SDL_Texture *texture = SDL_CreateTextureFromSurface(renderer, image);
	if (!texture) {
		fprintf(stderr, "Failed to cerate texture: %s\n", SDL_GetError());
		return 4;
	}
	SDL_Texture *texturebg = SDL_CreateTextureFromSurface(renderer, imagebg);
	if (!texturebg) {
		fprintf(stderr, "Failed to cerate texture: %s\n", SDL_GetError());
		return 4;
	}
	SDL_Texture *texturebalo = SDL_CreateTextureFromSurface(renderer, imagebalo);
	if (!texturebalo) {
		fprintf(stderr, "Failed to cerate texture: %s\n", SDL_GetError());
		return 4;
	}

	SDL_Rect src = {0, 0, 100, 100};
	SDL_Rect dst = {0, 0, 100, 100};
	SDL_Rect src2 = {0, 0, 100, 100};
	SDL_Rect dst2 = {0, 0, 100, 100};
	SDL_Rect src3 = {0, 0, 100, 100};
	SDL_Rect dst3 = {0, 0, 100, 100};
	SDL_Rect src4 = {0, 0, 100, 100};
	SDL_Rect dst4 = {0, 0, 100, 100};
	SDL_Rect src5 = {0, 0, 100, 100};
	SDL_Rect dst5 = {0, 0, 100, 100};
	SDL_Rect src6 = {0, 0, 100, 100};
	SDL_Rect dst6 = {0, 0, 100, 100};
	SDL_Rect src7 = {0, 0, 800, 600};
	SDL_Rect dst7 = {0, 0, 800, 600};
	SDL_Rect bound = {0, 0, WIN_WIDTH, WIN_HEIGHT};
	dst2.x = -100;
	dst3.x = -200;
	dst4.x = -300;
	dst5.x = -400;
	dst6.x = -500;
	int i = 0;
	int s = 1;
while (s){

	SDL_Event event;
	SDL_PollEvent(&event);
	switch (event.type){
				case SDL_QUIT:
					s = 0;
					return 0;
				default:
					break;
	}

	i++;
	dst.y =250;
	dst.x = dst.x + i;
	dst2.y =250;
	dst2.x = dst2.x + i;
	dst3.y =250;
	dst3.x = dst3.x + i;
	dst4.y =250;
	dst4.x = dst4.x + i;
	dst5.y =250;
	dst5.x = dst5.x + i;
	dst6.y =250;
	dst6.x = dst6.x + i;
	SDL_RenderClear(renderer);
	SDL_SetRenderDrawColor(renderer, 255, 0, 0, 255);
	SDL_RenderFillRect(renderer, &bound);
	SDL_RenderCopy(renderer, texturebg, &src7, &dst7);
	SDL_RenderCopy(renderer, texture, &src, &dst);
	SDL_RenderCopy(renderer, texture, &src2, &dst2);
	SDL_RenderCopy(renderer, texture, &src3, &dst3);
	SDL_RenderCopy(renderer, texture, &src4, &dst4);
	SDL_RenderCopy(renderer, texture, &src5, &dst5);
	SDL_RenderCopy(renderer, texturebalo, &src6, &dst6);
	SDL_RenderPresent(renderer);

	SDL_Delay(200);

}
	SDL_DestroyTexture(texture);
	SDL_FreeSurface(image);
	SDL_DestroyRenderer(renderer);
	SDL_DestroyWindow(window);

	return 0;

}
